/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SolarPoweredProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_ACTIVE_REPORTING = 17;

    public SolarPoweredProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(0, 15);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 17) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            block5: while (buf.readableBytes() > 2) {
                short tag = buf.readUnsignedByte();
                short length = buf.readUnsignedByte();
                switch (tag) {
                    case 129: {
                        short status = buf.readUnsignedByte();
                        DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                        position.setTime(dateBuilder.getDate());
                        position.setLatitude((double)buf.readUnsignedInt() * 1.0E-6);
                        if (BitUtil.check(status, 3)) {
                            position.setLatitude(-position.getLatitude());
                        }
                        position.setLongitude((double)buf.readUnsignedInt() * 1.0E-6);
                        if (BitUtil.check(status, 2)) {
                            position.setLongitude(-position.getLongitude());
                        }
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                        short temperature = buf.readUnsignedByte();
                        if (BitUtil.check(temperature, 7)) {
                            position.set("deviceTemp", -BitUtil.to(temperature, 7));
                        } else {
                            position.set("deviceTemp", BitUtil.to(temperature, 7));
                        }
                        position.set("battery", (double)buf.readUnsignedByte() * 0.02);
                        position.setCourse(buf.readUnsignedByte());
                        continue block5;
                    }
                    case 130: {
                        short alarmMask = buf.readUnsignedByte();
                        short alarm = buf.readUnsignedByte();
                        if (BitUtil.check(alarmMask, 0) && BitUtil.check(alarm, 0)) {
                            position.set("alarm", "tampering");
                        }
                        if (BitUtil.check(alarmMask, 1) && BitUtil.check(alarm, 1)) {
                            position.set("alarm", "lowPower");
                        }
                        if (BitUtil.check(alarmMask, 2) && BitUtil.check(alarm, 2)) {
                            position.set("alarm", "sos");
                        }
                        if (BitUtil.check(alarmMask, 3) && BitUtil.check(alarm, 3)) {
                            position.set("alarm", "fallDown");
                        }
                        if (!BitUtil.check(alarmMask, 4)) continue block5;
                        position.set("motion", BitUtil.check(alarm, 4));
                        continue block5;
                    }
                    case 131: {
                        buf.readUnsignedInt();
                        buf.readUnsignedInt();
                        buf.readUnsignedInt();
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        position.set("rssi", buf.readUnsignedByte());
                        continue block5;
                    }
                }
                buf.skipBytes((int)length);
            }
            return position;
        }
        return null;
    }
}

