@extends('layouts.master_panel')

@section('title') Dossiers @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}


</style>

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

@stop


@section('content')
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Dossiers </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Dossiers</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    
  <div class="card-body">





<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

<div class="row">
@foreach($folders as $folder)

<div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
  <div class="card card-figure">

<a href="{{ URL::route('enseignant_dossiers_files', $folder->id) }}">
      <figure class="figure">
        <div class="figure-attachment">
          <span class="fa-stack fa-lg">
            @if($folder->teacher_id == 1)
            <i class="fa fa-square fa-stack-2x text-warning"></i>
            @else
            <i class="fa fa-square fa-stack-2x text-primary"></i>
            @endif
            <i class="fa fa-folder fa-stack-1x fa-inverse"></i>
          </span>
        </div>
        <figcaption class="figure-caption">
          <ul class="list-inline d-flex text-muted mb-0">
            <li class="list-inline-item text-truncate mr-auto">
              {{ html_entity_decode($folder->folder_name) }}

              <p class="text-muted"><i class="fa fa-file"></i> <small><strong>{{ count(App\EnseignantsFiles::where('folder_id', $folder->id)->get()) }}</strong> ressources</small>

              <?php $GetClass = \App\Classes::find($folder->class_id); ?> 
              @if($GetClass !== null) <i class="fa fa-table"></i> <small><strong>{{ $GetClass->name }}</strong></small> @endif

              <br> <i class="fa fa-user"></i> <small>
                {{ $folder->teacher->last_name . ' ' . $folder->teacher->first_name }}
              </small></p>
@if(auth()->user()->super_admin == 1)
              <a href="#" data-toggle="modal" data-target="#exampleModal-{{ $folder->id }}" class="btn btn-outline-primary btn-xs"><i class="fa fa-edit"></i> Modifier</a>

              <a onclick="return confirm('Supprimer?')" href="{{ URL::route('folder_delete', $folder->id) }}" class="btn btn-outline-danger btn-xs"><i class="fa fa-trash"></i> Supprimer</a>
@endif
            </li>
          </ul>
        </figcaption>
      </figure>
</a>

    </div>
  </div>        



<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $folder->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $folder->id }}" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $folder->id }}">Renommer</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('folder_update', $folder->id) }}">

{{ csrf_field() }}


  <div class="col-md-12">
    <div class="form-group">
    <label>Nom de dossier:</label>
    <input name="folder_name_up" type="text" class="form-control input-lg" value="<?php echo html_entity_decode($folder->folder_name); ?>" required>
    </div>
  </div>



<div class="col-md-12 mb-4">
      <label>Classes:</label>
      <select name="class_id_up" class="selectpicker" data-width="100%" required="required"> 

@if($GetClass !== null) 
<option value="{{ $GetClass->id }}">{{ $GetClass->name }}</option>
@else
<option value="">Choisir</option>
@endif 
      
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach

      </select>
</div>


<div class="clearfix"></div><br>

<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Renommer</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


@endforeach
</div>

    </div>
  </div>
</div>


<div class="clearfix"></div>
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
   {{ $folders->links() }}
</div>
                          
</div><!-- END row -->

                    

@stop