<!doctype html>
<html lang="fr">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap/css/bootstrap.min.css">

    <title>Imprimer {{ $journal->id }}</title>

    <style type="text/css">
      @page { size: a4;  }

      @media print {
        @page { size: a4;  }
      }
    </style>


</head>

<body class="p-3" onload="window.print();">

<?php 
function convertToHoursMins($time, $format = '%02d:%02d') {
    if ($time < 1) {
        return;
    }
    $hours = floor($time / 60);
    $minutes = ($time % 60);
    return sprintf($format, $hours, $minutes);
}
 ?>  

<div class="col-md-12">


    <h4><strong>Date:</strong> {{ $journal->date }}</h4>

    <h4><strong>Enseignant:</strong> {{ $journal->teacher->last_name . ' ' . $journal->teacher->first_name }} </h4>

    <h4><strong>Heure:</strong> {{ $journal->hour_start }} à {{ $journal->hour_end }}</h4>

    <h4><strong>La duré:</strong> <?php echo convertToHoursMins($journal->hours_differance, '%02d heures %02d minutes'); ?></h4>

    <div class="border-top mt-4 mb-3 pt-3">
       <?php echo html_entity_decode($journal->details); ?>
    </div>
   


</div>

</body>
</html>