@extends('layouts.master_panel')

@section('title') Préparation à l'exam  @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

</script>


<script src="{{url('/')}}/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 150

        });
    });
</script>


<script type="text/javascript">
function ValidateSize(file) {
  var FileSize = file.files[0].size / 1024 / 1024; // in MB
  if (FileSize > 10) {
      $('#file').val(''); //for clearing with Jquery
      alert('La taille du fichier dépasse 10 Mo');
      
  } 
}
</script>

@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Préparation à l'exam </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Préparation à l'exam </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">



<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

  <div class="card">

  <div class="card-body">


      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>Préparation à</th>
              <th style="width: 20%">Titre</th>
              <th>Classe/Matière</th>
              <th>Enseignant</th>
              <th>détails</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

@foreach($devoirs as $devoir)

@if(!empty($devoir->preparation_exam))

                <tr>

                  <td style="display: none;">{{ $devoir->id }}</td>

                  <th><span class="badge badge-primary"><i class="fa fa-info-circle"></i> Préparation à l'exam {{ $devoir->preparation_exam }} </span></th>
                                    
                  <td>{{ $devoir->title }}</td>

                  <td>
                    <?php $FindSubject = \App\Subjects::find($devoir->subject_id); ?>
                    {{ $devoir->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>

                  <td>{{ $devoir->teacher->last_name . ' ' . $devoir->teacher->first_name }}</td>
                  

                  <td>

                    <a class="btn btn-primary btn-sm mb-1" href="#" data-toggle="modal" data-target="#exampleModal-{{ $devoir->id }}"><i class="fa fa-eye"></i> détail</a>

                    @if(!empty($devoir->file_join))
                      <a target="_black" class="btn btn-info btn-sm mb-1" href="{{ url('/') }}/uploads/devoirs/{{ $devoir->file_join }}"><i class="fa fa-download"></i> Fichier joint</a>
                    @endif


      
<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $devoir->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $devoir->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $devoir->id }}">détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

      <?php echo html_entity_decode($devoir->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
                    
                  </td>

                      <td>
@if(auth()->user()->super_admin == 1)
                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('devoirs_delete', $devoir->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
@endif                      
                      </td>

                    </tr>
@endif

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop