@extends('layouts.master_panel')

@section('title') Orientation @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>



@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Orientation</h3>
                          
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">

  <a href="{{ URL::route('exporter_orientation') }}" class="btn btn-primary mb-3"><i class="fa fa-file-excel"></i> Exporter Excel </a>

  <a href="{{ URL::route('orientation_classes') }}" class="btn btn-primary mb-3"><i class="fas fa-map-signs"></i> الشعب </a>

  </h5>
  <div class="card-body">



@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif



@if(isset($_GET['id']))

<?php 
$getOrient = \App\OrientationStudents::find(e($_GET['id']));

$CheckOrient = \App\Orientation::find($getOrient->orient_id);

 ?>


<form method="POST" action="{{ URL::route('update_orientation', $getOrient) }}" class="mb-5">

{{ csrf_field() }}

<div class="form-row">

<div class="col-md-4 mb-2">
    <div class="form-group">
    <label>Nom:</label>
    <input name="last_name" type="text" class="form-control input-lg" value="{{ $getOrient->student->last_name }}" readonly="readonly">
    </div>
</div>

<div class="col-md-4 mb-2">
    <div class="form-group">
    <label>Prénom:</label>
    <input name="first_name" type="text" class="form-control input-lg" value="{{ $getOrient->student->first_name  }}" readonly="readonly">
    </div>
</div>

<div class="col-md-4 mb-2">
    <div class="form-group">
    <label>Classe:</label>
    <input name="first_name" type="text" class="form-control input-lg" value="{{ $getOrient->classe->name }}" readonly="readonly">
    </div>
</div>

@if($CheckOrient !== null) 
  <div class="col-md-12 mb-3">
      <label>اختر الشعبة :</label>
      <select name="orientation" class="selectpicker" data-width="100%" title="اختر الشعبة " required="required"> 
        <?php $pieces = explode(",", $CheckOrient->orientations); ?> 
        <option selected="selected" value="{{ $getOrient->orientation }}">Choisir</option> 
        @foreach($pieces as $piec)
          @if($piec !== '') 
            <option value="{{ $piec }}">{{ $piec }}</option>
          @endif
        @endforeach
      </select>
  </div>
@endif

</div>

<div class="form-row mt-2">
<div class="col-md-8">
    <button class="btn btn-success btn-block" type="submit"><i class="fas fa-check-circle mr-2"></i>تأكيد</button>
</div>
<div class="col-md-4">
  <a href="{{ URL::route('admin_orientation') }}" class="btn btn-dark btn-block">إلغاء</a>
</div>
</div>

</form>


<div class="clearfix"></div><hr>

 @endif
<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Élève</th>
              <th>Classe</th>
              <th>الشعبة</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

@foreach($orientation_students as $orientation_student)

              <tr>

                  <td style="display: none;">{{ $orientation_student->id }}</td>

                                  
                  <td>{{ $orientation_student->student->last_name . ' ' . $orientation_student->student->first_name }}</td>

                  <td>{{ $orientation_student->classe->name }}</td>
                  
                  <td><span class="badge badge-info">{{ $orientation_student->orientation }}</span> 
                  </td>


                  <td>
                    @if(auth()->user()->super_admin == 1)
                    <a href="{{ \URL::current() . '?id=' . $orientation_student->id }}" class="btn btn-success btn-sm"><i class="fa fa-edit"></i>  Modifier</a>

                    <a onclick="return confirm('Supprimer?')" href="{{ URL::route('delete_orientation', $orientation_student->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>

                    @endif
                  </td>

              </tr>

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop