@extends('layouts.master_panel')

@section('title') Dossiers @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}


</style>

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

@stop


@section('content')
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Dossiers </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Dossiers</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">

@if(auth()->user()->super_admin == 1)
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-folder"></i> Nouveau dossier </a>
@endif

@if(auth()->user()->is_admin == 1)
    <a href="#" class="btn btn-primary ml-1 mb-1" data-toggle="modal" data-target="#exampleModal2"><i class="fas fa-users"></i> Enseignants (n'ont pas déposé)</a>
@endif

<?php 
$settings = \App\Settings::first();
$allyears = \App\AcademicYear::where('id', '!=', $settings->default_year)->orderBy('id', 'desc')->get(); 
?>

@foreach($allyears as $ayear)
<a href="{{ URL::route('admin_old_dossiers', $ayear->id) }}" class="btn btn-brand mb-1" ><i class="fa fa-calendar"></i> Dossiers de l'ancienne année ({{ $ayear->name }}) </a>
@endforeach

    </h5>
  <div class="card-body">



<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel2">Enseignants (n'ont pas déposé)</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">


<?php 

//$monday = strtotime('last monday', strtotime(date('2021-04-22')));
$monday = strtotime('last monday', strtotime('tomorrow'));
$sunday = strtotime('+5 days', $monday);
//echo "<P>". date('Y-m-d', $monday) . " to " . date('Y-m-d', $sunday) . "</P>";

$from = date('Y-m-d', $monday) . ' 00:00:01';
$to = date('Y-m-d', $sunday) . ' 23:59:59';

$fromFR = \DateTime::createFromFormat('Y-m-d', date('Y-m-d', $monday)); 
$toFR = \DateTime::createFromFormat('Y-m-d', date('Y-m-d', $sunday)); 

$CheckEnseignantsFiles = \App\EnseignantsFiles::whereBetween('created_at', [$from, $to])->get();

$array_ids = array();
foreach ($CheckEnseignantsFiles as $CheckEnseignantsFile) {
  $array_ids[] = $CheckEnseignantsFile->teacher_id;
}

$listNotDepose = \App\User::where('is_teacher', true)->whereNotIn('id', $array_ids)->orderBy('last_name', 'asc')->get();

?>
      <h3 class="text-center">Liste des enseignants <strong class="text-danger">(n'ont pas déposé)</strong> | du {{ $fromFR->format('d/m/Y') }} au {{ $toFR->format('d/m/Y') }}</h3>

<a target="_block" href="{{ URL::route('enseignants_nondepose') }}" class="btn btn-primary mt-3 mb-1"><i class="fas fa-print"></i> Imprimer</a>


<div class="table-responsive">
          <table  class="table table-bordered">
            <thead>
            <tr class="text-uppercase">
              <th>Enseignant(e)</th>
            </tr>
            </thead>
            <tbody>
@foreach($listNotDepose as $listNotDepo)

              <tr>
              <td>{{ $listNotDepo->last_name . ' ' . $listNotDepo->first_name }}</td>          
              </tr>
@endforeach
            </tbody>
          </table>
</div>



    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Nouveau dossier</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('folders_store') }}">

{{ csrf_field() }}


  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Nouveau dossier:</label>
    <input name="folder_name" type="text" class="form-control input-lg" value="{{ old('folder_name') }}" required>
    </div>
  </div>


<div class="col-md-12 mb-4">
      <label>Classes:</label>
      <select name="class_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach
      </select>
</div>


<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Ajouter</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

<div class="row">
@foreach($folders as $folder)

<div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
  <div class="card card-figure">

<a href="{{ URL::route('enseignant_dossiers_files', $folder->id) }}">
      <figure class="figure">
        <div class="figure-attachment">
          <span class="fa-stack fa-lg">
            @if($folder->teacher_id == 1)
            <i class="fa fa-square fa-stack-2x text-warning"></i>
            @else
            <i class="fa fa-square fa-stack-2x text-primary"></i>
            @endif
            <i class="fa fa-folder fa-stack-1x fa-inverse"></i>
          </span>
        </div>
        <figcaption class="figure-caption">
          <ul class="list-inline d-flex text-muted mb-0">
            <li class="list-inline-item text-truncate mr-auto">
              {{ html_entity_decode($folder->folder_name) }}

              <p class="text-muted"><i class="fa fa-file"></i> <small><strong>{{ count(App\EnseignantsFiles::where('folder_id', $folder->id)->get()) }}</strong> ressources</small>

              <?php $GetClass = \App\Classes::find($folder->class_id); ?> 
              @if($GetClass !== null) <i class="fa fa-table"></i> <small><strong>{{ $GetClass->name }}</strong></small> @endif

              <br> <i class="fa fa-user"></i> <small>
                {{ $folder->teacher->last_name . ' ' . $folder->teacher->first_name }}
              </small></p>
@if(auth()->user()->super_admin == 1)
              <a href="#" data-toggle="modal" data-target="#exampleModal-{{ $folder->id }}" class="btn btn-outline-primary btn-xs"><i class="fa fa-edit"></i> Modifier</a>

              <a onclick="return confirm('Supprimer?')" href="{{ URL::route('folder_delete', $folder->id) }}" class="btn btn-outline-danger btn-xs"><i class="fa fa-trash"></i> Supprimer</a>
@endif
            </li>
          </ul>
        </figcaption>
      </figure>
</a>

    </div>
  </div>        



<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $folder->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $folder->id }}" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $folder->id }}">Renommer</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('folder_update', $folder->id) }}">

{{ csrf_field() }}


  <div class="col-md-12">
    <div class="form-group">
    <label>Nom de dossier:</label>
    <input name="folder_name_up" type="text" class="form-control input-lg" value="<?php echo html_entity_decode($folder->folder_name); ?>" required>
    </div>
  </div>



<div class="col-md-12 mb-4">
      <label>Classes:</label>
      <select name="class_id_up" class="selectpicker" data-width="100%" required="required"> 

@if($GetClass !== null) 
<option value="{{ $GetClass->id }}">{{ $GetClass->name }}</option>
@else
<option value="">Choisir</option>
@endif 
      
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach

      </select>
</div>


<div class="clearfix"></div><br>

<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Renommer</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


@endforeach
</div>

    </div>
  </div>
</div>


<div class="clearfix"></div>
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
   {{ $folders->links() }}
</div>
                          
</div><!-- END row -->

                    

@stop