

<?php $__env->startSection('title'); ?> Planning des devoirs <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 


<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


<?php $__env->stopSection(); ?>

<?php $__env->startSection('JS'); ?> 


<script src="<?php echo e(url('/')); ?>/js/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "<?php echo e(url('/')); ?>/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>




<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/moment.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/datepicker.js"></script>

<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateTWO').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });
</script>




<script type="text/javascript">
function ValidateSize(file) {
  var FileSize = file.files[0].size / 1024 / 1024; // in MB
  if (FileSize > 50) {
      $('#file').val(''); //for clearing with Jquery
      alert('La taille du fichier dépasse 50 Mo');
      
  } 
}
</script>




<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Planning des devoirs  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Planning des devoirs  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">

    <h5 class="card-header">

<?php if(auth()->user()->super_admin == 1): ?> 
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
<?php endif; ?>

    </h5>
   
  <div class="card-body">

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('planning_devoirs_store')); ?>" enctype="multipart/form-data">

<?php echo e(csrf_field()); ?>



<div class="form-row">


  <div class="col-md-12 mb-3">
      <label>Classes</label>
      <select name="class_id[]" class="selectpicker" data-width="100%" title="Choisir" required="required" multiple="multiple">
        <option value="all">Tout sélectionner</option>   
        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($classe->id); ?>"><?php echo e($classe->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
  </div>



<div class="col-md-6 mb-3">
    <label>Date du:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date_du" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>


<div class="col-md-6 mb-3">
    <label>Date au:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdateTWO" data-target-input="nearest">

    <input name="date_au" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateTWO" required="required" value="" />
    
      <div class="input-group-append" data-target="#datetimepickerdateTWO" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>



<div class="col-md-12 mb-3">
      <label>Planning PDF:</label>
        <div class="custom-file">
          <input type="file" id="file" name="file_join" required="required" onchange="ValidateSize(this)">
        </div>
        <?php if($errors->first('file_join')): ?>
          <small class="form-text text-danger"><?php echo e($errors->first('file_join')); ?></small>
        <?php endif; ?>
</div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->



<div class="clearfix"></div>

<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>Classe</th>
              <th>Date</th>
              <th>Télécharger</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

<?php $__currentLoopData = $planning_devoirs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planning_devoir): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


      <tr>

            <td style="display: none;"><?php echo e($planning_devoir->id); ?></td>
                  

              <td><?php echo e($planning_devoir->classe->name); ?> </td>

              <td><?php echo e($planning_devoir->date_du); ?> - <?php echo e($planning_devoir->date_au); ?></td>


                  <td>
                    <a class="btn btn-rounded btn-dark btn-sm" target="_black" href="<?php echo e(url('/')); ?>/uploads/planning_devoirs/<?php echo e($planning_devoir->fichier); ?>"><i class="fas fa-download"></i></a>
                  </td>


                    <td>
                      <?php if(auth()->user()->super_admin == 1): ?>
                      <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('planning_devoirs_delete', $planning_devoir->id)); ?>" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i>  </a>
                      <?php endif; ?>

                    </td>

   </tr>


<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/admin/planning_devoirs.blade.php ENDPATH**/ ?>