@extends('layouts.master_panel')

@section('title') Mes dossiers @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}


</style>

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

@stop


@section('content')
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Mes dossiers </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Mes dossiers</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <div class="card-body">


<div class="row">
@foreach($folders as $folder)


<div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
  <div class="card card-figure">

<a href="{{ URL::route('students_ressources', $folder->id) }}">
      <figure class="figure">
        <div class="figure-attachment">
          <span class="fa-stack fa-lg">
            <i class="fa fa-square fa-stack-2x text-primary"></i>
            <i class="fa fa-folder fa-stack-1x fa-inverse"></i>
          </span>
        </div>
        <figcaption class="figure-caption">
          <ul class="list-inline d-flex text-muted mb-0">
            <li class="list-inline-item text-truncate mr-auto">
              {{ html_entity_decode($folder->folder_name) }}
              
              <p class="text-muted"><i class="fa fa-file"></i> <small><strong>{{ count(App\EnseignantsFiles::where('folder_id', $folder->id)->get()) }}</strong> ressources</small>


              <br> <i class="fa fa-user"></i> <small>
                {{ $folder->teacher->last_name . ' ' . $folder->teacher->first_name }}
              </small></p>

            </li>
          </ul>
        </figcaption>
      </figure>
</a>

    </div>
  </div>        



@endforeach
</div>

    </div>
  </div>
</div>

                          
</div><!-- END row -->

                    

@stop